package gov.va.med.mhv.sm.web.util;

import java.util.ArrayList;
import java.util.List;

// import org.owasp.esapi.ESAPI;

public class HyperlinkWrapper {

	public static String encodeHtmlAndEnableHyperlinks(String content) {

		if (content == null) {
			return "";
		}

		List<HyperlinkIndex> linkList = extractLinksList(content);

		if (linkList.isEmpty()) {
			// return ESAPI.encoder().encodeForHTML(content);
			return content;
		} else {
			StringBuilder sb = new StringBuilder();
			int i = 0;
			for (HyperlinkIndex aLink : linkList) {
				// sb.append(ESAPI.encoder().encodeForHTML(content.substring(i, aLink.getBeginIndex())));
				sb.append(content.substring(i, aLink.getBeginIndex()));
				if (content.charAt(aLink.getEndIndex() - 4) == '.') {
					String tmp = content.substring(aLink.getEndIndex() - 3, aLink.getEndIndex());
					if (tmp.equalsIgnoreCase("gif") || tmp.equalsIgnoreCase("jpg") || tmp.equalsIgnoreCase("png")) {
						sb.append("<span><img src=\"").append(content.substring(aLink.getBeginIndex(), aLink.getEndIndex()))
								.append("\" alt=\"This is a external image\"></img></span>");
					} else {
						sb.append("<a href=\"").append(content.substring(aLink.getBeginIndex(), aLink.getEndIndex())).append("\" target=\"_blank\">")
								.append(content.substring(aLink.getBeginIndex(), aLink.getEndIndex())).append("</a>");
					}
				} else {
					sb.append("<a href=\"").append(content.substring(aLink.getBeginIndex(), aLink.getEndIndex())).append("\" target=\"_blank\">")
							.append(content.substring(aLink.getBeginIndex(), aLink.getEndIndex())).append("</a>");
				}
				i = aLink.getEndIndex();
			}
			if (i < content.length()) {
				// sb.append(ESAPI.encoder().encodeForHTML(content.substring(i)));
				sb.append(content.substring(i));
			}

			return sb.toString();
		}
	}

	private static List<HyperlinkIndex> extractLinksList(CharSequence input) {

		int length = input.length();
		int i = 0;

		List<HyperlinkIndex> list = new ArrayList<HyperlinkIndex>();

		while (i < length) {
			if (input.charAt(i) == ':') {
				if (input.charAt(i + 1) == '/' && input.charAt(i + 2) == '/') {
					char c = Character.toLowerCase(input.charAt(i - 1));
					if (c == 's') {
						if (input.subSequence(i - 5, i).toString().equalsIgnoreCase("https")) {
							int begin = i - 5;
							int end = findUrlEnd(input, begin);
							// https://a.tv --> OK.
							if (((end + 1) - begin) >= 12) {
								list.add(new HyperlinkIndex(begin, end + 1));
							}
						}
					} else if (c == 'p') {
						if (input.subSequence(i - 4, i).toString().equalsIgnoreCase("http")) {
							int begin = i - 4;
							int end = findUrlEnd(input, begin);
							// http://a.tv --> OK.
							if (((end + 1) - begin) >= 11) {
								list.add(new HyperlinkIndex(begin, end + 1));
							}
						}
					}// else if(c=='p')
				}
			}// if(input.charAt(i)== ':')
			i++;
		}

		return list;
	}

	private static int findUrlEnd(CharSequence input, int beginIndex) {
		int round = 0;
		int square = 0;
		int curly = 0;
		boolean doubleQuote = false;
		boolean singleQuote = false;
		int last = beginIndex;
		loop: for (int i = beginIndex; i < input.length(); i++) {
			char c = input.charAt(i);
			switch (c) {
			case '\u0000':
			case '\u0001':
			case '\u0002':
			case '\u0003':
			case '\u0004':
			case '\u0005':
			case '\u0006':
			case '\u0007':
			case '\u0008':
			case '\t':
			case '\n':
			case '\u000B':
			case '\f':
			case '\r':
			case '\u000E':
			case '\u000F':
			case '\u0010':
			case '\u0011':
			case '\u0012':
			case '\u0013':
			case '\u0014':
			case '\u0015':
			case '\u0016':
			case '\u0017':
			case '\u0018':
			case '\u0019':
			case '\u001A':
			case '\u001B':
			case '\u001C':
			case '\u001D':
			case '\u001E':
			case '\u001F':
			case ' ':
			case '<':
			case '>':
			case '\u007F':
			case '\u0080':
			case '\u0081':
			case '\u0082':
			case '\u0083':
			case '\u0084':
			case '\u0085':
			case '\u0086':
			case '\u0087':
			case '\u0088':
			case '\u0089':
			case '\u008A':
			case '\u008B':
			case '\u008C':
			case '\u008D':
			case '\u008E':
			case '\u008F':
			case '\u0090':
			case '\u0091':
			case '\u0092':
			case '\u0093':
			case '\u0094':
			case '\u0095':
			case '\u0096':
			case '\u0097':
			case '\u0098':
			case '\u0099':
			case '\u009A':
			case '\u009B':
			case '\u009C':
			case '\u009D':
			case '\u009E':
			case '\u009F':
				// These can never be part of an URL, so stop now. See RFC 3986
				// and RFC 3987.
				// Some characters are not in the above list, even they are not
				// in "unreserved" or "reserved":
				// '"', '\\', '^', '`', '{', '|', '}'
				// The reason for this is that other link detectors also allow
				// them. Also see below, we require
				// the quote and the braces to be balanced.
				break loop;
			case '?':
			case '!':
			case '.':
			case ',':
			case ':':
			case ';':
				// These may be part of an URL but not at the end
				break;
			case '/':
				// This may be part of an URL and at the end, but not if the
				// previous character can't be the end of an URL
				if (last == i - 1) {
					last = i;
				}
				break;
			case '(':
				round++;
				break;
			case ')':
				round--;
				if (round >= 0) {
					last = i;
				} else {
					// More closing than opening brackets, stop now
					break loop;
				}
				break;
			case '[':
				// Allowed in IPv6 address host
				square++;
				break;
			case ']':
				// Allowed in IPv6 address host
				square--;
				if (square >= 0) {
					last = i;
				} else {
					// More closing than opening brackets, stop now
					break loop;
				}
				break;
			case '{':
				curly++;
				break;
			case '}':
				curly--;
				if (curly >= 0) {
					last = i;
				} else {
					// More closing than opening brackets, stop now
					break loop;
				}
				break;
			case '"':
				doubleQuote = !doubleQuote;
				if (!doubleQuote) {
					last = i;
				}
				break;
			case '\'':
				singleQuote = !singleQuote;
				if (!singleQuote) {
					last = i;
				}
				break;
			default:
				last = i;
			}
		}
		return last;
	}

}
